% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_ref_temp.R
\name{calculate_pars_correlation}
\alias{calculate_pars_correlation}
\title{Correlation Between Model Parameters Sensitivities}
\usage{
calculate_pars_correlation(inactivation_model, parms, temp_profile, parms_fix,
  n_times = 100, sensvar = "logN")
}
\arguments{
\item{inactivation_model}{Character defining the inactivation model to use.}

\item{parms}{Numeric vector with the nominal values of the model parameters.}

\item{temp_profile}{Data frame describing the environmental conditions.}

\item{parms_fix}{Nominal value of the parameters not considered for the
sensitivity.}

\item{n_times}{Numeric value specifying the nombers of time points where 
the sensitivity functions will be calculated. 100 by default.}

\item{sensvar}{The output variable for which the sensitivity will be 
estimated. \code{"logN"} by default.}
}
\description{
Correlation Between Model Parameters Sensitivities
}
\examples{

parms_fix <- c(temp_ref = 57.5)
parms <- c(delta_ref = 3.9, z = 4.2, p = 1, N0 = 1e6)
temp_profile <- data.frame(time = c(0, 60), temperature = c(30, 60))
correlations <- calculate_pars_correlation("Mafart", parms,
                                            temp_profile, parms_fix)
plot(correlations)

}

