% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_vp.R
\name{calculate_vp}
\alias{calculate_vp}
\title{Calculate a vertical profile (\code{vp}) from a polar volume (\code{pvol})}
\usage{
calculate_vp(pvolfile, vpfile = "", pvolfile_out = "",
  autoconf = FALSE, verbose = FALSE, mount = dirname(pvolfile),
  sd_vvp_threshold = 2, rcs = 11, dual_pol = FALSE, rho_hv = 0.95,
  elev_min = 0, elev_max = 90, azim_min = 0, azim_max = 360,
  range_min = 5000, range_max = 25000, n_layer = 20L,
  h_layer = 200, dealias = TRUE, nyquist_min = if (dealias) 5 else
  25, dbz_quantity = "DBZH")
}
\arguments{
\item{pvolfile}{A radar file containing a radar polar volume, either in
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM}
format, which is the implementation of the OPERA data information model in
\href{https://support.hdfgroup.org/HDF5/}{HDF5} format, or a format
supported by the
\href{http://trmm-fc.gsfc.nasa.gov/trmm_gv/software/rsl/}{RSL library}.}

\item{vpfile}{character. Filename for the vertical profile to be
generated in ODIM HDF5 format (optional).}

\item{pvolfile_out}{character. Filename for the polar volume to be
generated in ODIM HDF5 format (optional, e.g. for converting RSL formats
to ODIM).}

\item{autoconf}{logical. When TRUE, default optimal configuration settings
are selected automatically, and other user settings are ignored.}

\item{verbose}{logical. When TRUE, pipe Docker stdout to R console. On
Windows always TRUE.}

\item{mount}{character. String with the mount point (a directory path) for
the Docker container.}

\item{sd_vvp_threshold}{numeric. Lower threshold in radial velocity standard
deviation (profile quantity \code{sd_vvp}) in m/s. Biological signals with
\code{sd_vvp} < \code{sd_vvp_threshold} are set to zero.}

\item{rcs}{numeric. Radar cross section per bird in cm^2.}

\item{dual_pol}{logical. When \code{TRUE} use dual-pol mode, in which
meteorological echoes are filtered using the correlation coefficient
\code{rho_hv}. When \code{FALSE} use single polarization mode based only
on reflectivity and radial velocity quantities.}

\item{rho_hv}{numeric. Lower threshold in correlation coefficient used to
filter meteorological scattering.}

\item{elev_min}{numeric. Minimum scan elevation in degrees.}

\item{elev_max}{numeric. Maximum scan elevation in degrees.}

\item{azim_min}{numeric. Minimum azimuth in degrees clockwise from north.}

\item{azim_max}{numeric. Maximum azimuth in degrees clockwise from north.}

\item{range_min}{numeric. Minimum range in km.}

\item{range_max}{numeric. Maximum range in km.}

\item{n_layer}{numeric. Number of altitude layers in the profile.}

\item{h_layer}{numeric. Width of altitude layers in meter.}

\item{dealias}{logical. Whether to dealias radial velocities; this should
typically be done when the scans in the polar volume have low Nyquist
velocities (below 25 m/s).}

\item{nyquist_min}{numeric. Minimum Nyquist velocity of scans in m/s for
scans to be included in the analysis.}

\item{dbz_quantity}{character. One of the available reflectivity factor
quantities in the ODIM radar data format, e.g. DBZH, DBZV, TH, TV.}
}
\value{
A vertical profile object of class \link[=summary.vp]{vp}. When
defined, output files \code{vpfile} and \code{pvolfile_out} are saved to disk.
}
\description{
Calculates a vertical profile of biological scatterers (vp) from a polar volume (pvol)
using the algorithm \href{https://github.com/adokter/vol2bird/}{vol2bird} (Dokter et al. 2011).
}
\details{
Requires a running \href{https://www.docker.com/}{Docker} daemon.

Common arguments set by users are \code{pvolfile}, \code{vpfile},
\code{autoconf} and \code{mount}.

Turn on \code{autoconf} to automatically select the optimal parameters for a
given radar file. The default for C-band data is to apply rain-filtering in
single polarization mode, as well as dual polarization mode when available.

The default for S-band data is to apply precipitation filtering in
dual-polarization mode.

Arguments that sometimes require non-default values are: \code{rcs},
\code{sd_vvp_threshold}, \code{range_max}, \code{dual_pol}, \code{dealias}.

Other arguments are typically left at their defaults.

\code{azim_min} and \code{azim_max} only affects reflectivity-derived
estimates in the profile (DBZH,eta,dens), not radial-velocity derived
estimates (u, v, w, ff, dd, sd_vvp), which are estimated on all azimuths at
all times. \code{azim_min}, \code{azim_max} may be set to exclude an angular
sector with high ground clutter.

\code{range_max} may be extended up to 40,000 m for volumes with low
elevations only, in order to extend coverage to higher altitudes.

For altitude layers with a VVP-retrieved radial velocity standard deviation
value below the threshold \code{sd_vvp_threshold}, the bird density \code{dens} is set
to zero (see vertical profile \link[=summary.vp]{vp} class). This threshold
might be dependent on radar processing settings. Results from validation
campaigns so far indicate that 2 m/s is the best choice for this parameter
for most weather radars.
The algorithm has been tested and developed for altitude layers with
\code{h_layer} = 200 m. Smaller widths are not recommended as they may cause
instabilities of the volume velocity profiling (VVP) and dealiasing routines,
and effectively lead to pseudo-replicated altitude data, since altitudinal
patterns smaller than the beam width cannot be resolved.

The default radar cross section (11 cm^2) corresponds to the average value
found by Dokter et al. in a calibration campaign of a full migration autumn
season in western Europe at C-band. It's value may depend on radar
wavelength. \code{rcs} will scale approximately \eqn{M^{2/3}} with \code{M}
the bird's mass.

Using default values of \code{range_min} and \code{range_max} is
recommended. Ranges closer than 5 km tend to be contaminated by ground
clutter, while range gates beyond 25 km become too wide to resolve the
default altitude layer width of 200 meter (see \link{beam_width}).

For dealiasing, the torus mapping method by Haase et al. is used.

At S-band (radar wavelength ~ 10 cm), currently only \code{dual_pol=TRUE}
mode is recommended.

On repeated calls of \code{calculate_vp}, the Docker container mount can be
recycled from one call to the next if subsequent calls share the same
\code{mount} argument. Re-mounting a Docker container takes time, therefore
it is advised to choose a mountpoint that is a parent directory of all
volume files to be processed, such that \code{calculate_vp} calls are as fast
as possible.
}
\examples{
# locate example polar volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# copy to a home directory with read/write permissions:
file.copy(pvolfile, "~/volume.h5")

# calculate the profile:
\dontrun{
profile <- calculate_vp("~/volume.h5")
}

# clean up:
file.remove("~/volume.h5")
}
\references{
\itemize{
  \item Haase, G. and Landelius, T., 2004. Dealiasing of Doppler radar
  velocities using a torus mapping. Journal of Atmospheric and Oceanic
  Technology, 21(10), pp.1566-1573.
  \item Bird migration flight altitudes studied by a network of
  operational weather radars, Dokter et al., J. R. Soc. Interface 8 (54),
  pp. 30--43, 2011. \url{https://doi.org/10.1098/rsif.2010.0116}
}
}
