% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_vpts}
\alias{example_vpts}
\title{Time series of vertical profiles (\code{vpts}) example}
\format{
An object of class \code{vpts} of dimension 1934 x 25 x 15.
}
\usage{
example_vpts
}
\description{
Example of a \code{\link[=summary.vpts]{vpts}} object with name \code{example_vpts}.
}
\examples{
# Reload example_vpts from package (e.g. in case it was altered)
data(example_vpts)

# Get summary info
example_vpts

# example_vpts was created with
\dontrun{
vptsfile <- system.file("extdata", "vpts.txt.zip", package = "bioRad")
unzip(vptsfile, exdir = (dirname(vptsfile)), junkpaths = TRUE)
vptsfile <- substr(vptsfile, 1, nchar(vptsfile) - 4)
example_vpts <- read_vpts(vptsfile, radar = "KBGM", wavelength = "S")
rcs(example_vpts) <- 11
sd_vvp_threshold(example_vpts) <- 2
example_vpts$attributes$where$lat <- 42.2
example_vpts$attributes$where$lon <- -75.98
save(example_vpts, file = "data/example_vpts.rda", compress = "xz")
}
}
\seealso{
\itemize{
\item \code{\link[=summary.vpts]{summary.vpts()}}
}
}
\keyword{datasets}
