% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpts.R
\name{[.vpts}
\alias{[.vpts}
\title{Subset a time series of vertical profiles (\code{vpts})}
\usage{
\method{[}{vpts}(x, i)
}
\arguments{
\item{x}{A \code{vpts} object.}

\item{i}{Integer. Index/indices specifying which range of vertical profiles
to extract.}
}
\value{
A \code{vpts} object containing a subset of vertical profiles (\code{vp}) or a
\code{vp} object when subsetting a single vertical profile (\code{vp}).
}
\description{
Select a vertical profile (\code{vp}) or a time series of vertical profiles
(\code{vpts}) by index from a \code{vpts}.
}
\examples{
# The example vpts contains 1934 profiles (i.e. datetimes)
dim(example_vpts)

# Subset vpts to extract 10th profile
example_vpts[10] # A vp object

# Subset vpts to extract the 20th to 100th profile
example_vpts[20:100] # A vpts object with 81 profiles

# Subset vpts to remove the first 10 profiles
example_vpts[-1:-10] # A vpts object with 10 less profiles
}
