test_that("download_basemap() returns error on incorrect parameters", {
  ppi <- project_as_ppi(example_scan)
  expect_error(
    download_basemap("a"),
    regexp = 'inherits(x, "ppi") is not TRUE',
    fixed = TRUE
  )
  # CRS absent in ppi
  ppi_no_crs <- ppi
  raster::crs(ppi_no_crs$data) <- NA
  expect_error(
    download_basemap(ppi_no_crs),
    regexp = "Not a projected ppi, download_basemap() expects a ppi generated by project_as_ppi() with argument project=TRUE",
    fixed = TRUE
  )
  # invalid value for zoom
  expect_error(
    download_basemap(ppi, zoom = "a"),
    regexp = "zoom should be a numeric integer",
    fixed = TRUE
  )
})
