% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_biotype.R
\name{biotype}
\alias{biotype}
\title{Bioclimatic classification}
\usage{
biotype(t = NULL, p = NULL, lat = NULL, wb = NULL, bb = NULL, CC = NULL, mode)
}
\arguments{
\item{t}{Numeric. Monthly temperature required for water balance calculation.}

\item{p}{Numeric. Monthly precipitation required for water balance calculation.}

\item{lat}{Numeric. Latitude required for water balance calculation.}

\item{wb}{Water balance in data.frame format from watbal() function. If provided, 't' and 'p' are not used.}

\item{bb}{Bioclimatic balancein data.frame format from biobal() function. If provided, 't', 'p' and 'wb' are not used.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. 400 as default value.}

\item{mode}{Type of output: "TBR", "sub", or "zonal". See details.}
}
\value{
character defining the type of climate.
}
\description{
Calculates bioclimatic classification based on bioclimatic balance.
}
\details{
Argument "mode" defines the type of return ("TBR": Types of Bioclimatic Regime; "zonal": zonal units; "sub": bioclimatic regime subtypes)
}
\examples{
# calculation of water balance
wb <- watbal(t = rnorm(12, 18, 6), p = rnorm(12, 50, 30), lat = 35, CC = 400)
# calculation of bioclimatic balance
bb <- biobal(wb, 400)

# bioclimatic classification at TBR levels
biotype(bb = bb, mode = 'TBR')

# bioclimatic classification at zonal levels
biotype(bb = bb, mode = 'zonal')

# bioclimatic classification at subtypes levels (requires water balance)
wb <- watbal(t = rnorm(12, 18, 6), p = rnorm(12, 50, 30), lat = 35, CC = 400)
biotype(wb = wb, CC = 400, mode = 'sub')

}
