% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_translocations.R
\name{calculate_trans_rate_sigurdson}
\alias{calculate_trans_rate_sigurdson}
\title{Calculate Sigurdson's translocation rate}
\usage{
calculate_trans_rate_sigurdson(
  cells,
  genome_factor,
  age_value,
  sex_bool = FALSE,
  sex_value = "none",
  smoker_bool = FALSE,
  ethnicity_value = "none",
  region_value = "none"
)
}
\arguments{
\item{cells}{Number of cells \code{N}.}

\item{genome_factor}{Genomic conversion factor.}

\item{age_value}{Age of the individual.}

\item{sex_bool}{If \code{TRUE}, \code{sex_value} will be used.}

\item{sex_value}{Sex of the individual, either "male" of "female".}

\item{smoker_bool}{Whether the individual smokes or not.}

\item{ethnicity_value}{Ethnicity of the individual.}

\item{region_value}{Region of the individual.}
}
\value{
Numeric value of translocation rate.
}
\description{
Method based on the paper by Sigurdson, A. J. et al. (2008). International
study of factors affecting human chromosome translocations. Mutation
Research/Genetic Toxicology and Environmental Mutagenesis, 652(2), 112-121.
<doi:10.1016/j.mrgentox.2008.01.005>.
}
