% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_estimation.R
\name{estimate_partial_body_dolphin}
\alias{estimate_partial_body_dolphin}
\title{Partial-body dose estimation (Dolphin's method)}
\usage{
estimate_partial_body_dolphin(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int = 0.95,
  protracted_g_value = 1,
  genome_factor = 1,
  gamma,
  aberr_module = c("dicentrics", "translocations", "micronuclei")
)
}
\arguments{
\item{case_data}{Case data in data frame form.}

\item{fit_coeffs}{Fitting coefficients matrix.}

\item{fit_var_cov_mat}{Fitting variance-covariance matrix.}

\item{conf_int}{Confidence interval, 95\% by default.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{genome_factor}{Genomic conversion factor used in translocations, else 1.}

\item{gamma}{Survival coefficient of irradiated cells.}

\item{aberr_module}{Aberration module.}
}
\value{
List containing estimated doses data frame, observed fraction of cells scored
which were irradiated, estimated fraction of irradiated blood data frame, AIC, and
\code{conf_int_*} used.
}
\description{
Method based on the paper by Dolphin, G. W. (1969). Biological Dosimetry with
Particular Reference to Chromosome Aberration Analysis: A Review of Methods.
International Atomic Energy Agency (IAEA) Retrieved from
\url{https://inis.iaea.org/search/search.aspx?orig_q=RN:45029080}.
}
