% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbLocation-class.R,
%   R/gbFeature-class.R, R/gbFeatureTable-class.R, R/gbRecord-class.R,
%   R/gbRecordList-class.R
\docType{methods}
\name{end}
\alias{end}
\alias{end<-}
\alias{end,gbLocation-method}
\alias{end<-,gbLocation-method}
\alias{end,gbFeature-method}
\alias{end<-,gbFeature-method}
\alias{end,gbFeatureTable-method}
\alias{end<-,gbFeatureTable-method}
\alias{end,gbRecord-method}
\alias{end,gbRecordList-method}
\title{Get or set the end position of genomic features}
\usage{
end(x, ...)

end(x, ...) <- value

\S4method{end}{gbLocation}(x, join = FALSE)

\S4method{end}{gbLocation}(x, ...) <- value

\S4method{end}{gbFeature}(x, join = FALSE)

\S4method{end}{gbFeature}(x, ...) <- value

\S4method{end}{gbFeatureTable}(x, join = FALSE)

\S4method{end}{gbFeatureTable}(x, ...) <- value

\S4method{end}{gbRecord}(x, join = FALSE)

\S4method{end}{gbRecordList}(x, join = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Further arguments passed to methods.}

\item{value}{The end information to set on \code{x}.}

\item{join}{Join compound genomic locations into a single range.}
}
\value{
An integer vector or a list of integer vectors.
}
\description{
Get or set the end position of genomic features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))

## end
end(x)
cds <- x["CDS"]
end(cds)

## `end<-`
end(cds) <- 1000
end(cds)
ranges(cds)
}
\seealso{
\code{\link{start}}, \code{\link{strand}}, \code{\link{span}}, \code{\link{ranges}}
}
