% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{getSequence}
\alias{getSequence}
\alias{getSequence,gbFeature-method}
\alias{getSequence,gbFeatureTable-method}
\alias{getSequence,gbRecord-method}
\alias{getSequence,gbRecordList-method}
\title{Get the sequence from a GenBank record.}
\usage{
getSequence(x, ...)

\S4method{getSequence}{gbFeature}(x)

\S4method{getSequence}{gbFeatureTable}(x)

\S4method{getSequence}{gbRecord}(x)

\S4method{getSequence}{gbRecordList}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} instance.}

\item{...}{Additional arguments passed to methods.}
}
\value{
An \code{\linkS4class{XStringSet}} object, containing either the
complete sequence(s) of the record(s), or of the selected feature(s)
}
\description{
Get the sequence from a GenBank record.
}
\examples{
\dontrun{
gbk_file <- system.file("extdata", "S_cerevisiae_mito.gb", package = "biofiles")
x <- gbRecord(gbk_file)

## extract the full-length sequence of the record.
getSequence(x)

## extract coding sequences only
getSequence(x["CDS"])
}
}
