% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/write-genbank.R
\docType{methods}
\name{write.GenBank}
\alias{write.GenBank}
\alias{write.GenBank,gbRecord-method}
\alias{write.GenBank,gbFeatureTable-method}
\title{Write GenBank records or features to file in GenBank format}
\usage{
write.GenBank(x, file, append = FALSE, ...)

\S4method{write.GenBank}{gbRecord}(x, file, header = TRUE, sequence = TRUE,
  append = FALSE)

\S4method{write.GenBank}{gbFeatureTable}(x, file, header = TRUE,
  sequence = TRUE, append = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbRecord}} instance.}

\item{file}{A connection or a character string naming the file to write to.}

\item{append}{if \code{TRUE} the data is appended to the connection.}

\item{...}{Additional arguments passed to methods.}

\item{header}{if \code{FALSE} exclude the Genbank header.}

\item{sequence}{if \code{FALSE} exclude the sequence.}
}
\description{
Write GenBank records or features to file in GenBank format
}
\details{
For a description of the GenBank format see
\url{http://www.ncbi.nlm.nih.gov/collab/FT/}
}
\examples{
\dontrun{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
write.GenBank(x, file = "data/marine_metagenome.gb")

## write selected features to file.
write.GenBank(x["CDS"], file = "data/marine_metagenome_cds.gb", header = FALSE, sequence = FALSE)
}
}
