% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/test_features.R
\name{test_features}
\alias{test_features}
\title{Permutation test for feature selection}
\usage{
test_features(target, features, criterion = "ig", adjust = "BH",
  threshold = 1, quick = TRUE, times = 1e+05)
}
\arguments{
\item{target}{\code{integer} vector with target information (e.g. class labels).}

\item{features}{\code{integer} matrix of features with number of rows equal
to the length of the target vector.}

\item{criterion}{criterion used in permutation test. See \code{\link{criterions}} for the
list of possible criterions.}

\item{adjust}{name of p-value adjustment method. See \code{\link[stats]{p.adjust}}
for the list of possible values. If \code{NULL}, no adjustment is done.}

\item{threshold}{\code{integer}. Features that occur less than \code{threshold}
and more often than \code{nrow(features)-threshold} are discarded from the permutation test.}

\item{quick}{\code{logical}, if \code{TRUE} Quick Permutation Test (QuiPT) is used.}

\item{times}{number of times procedure should be repeated. Ignored if \code{quick} is
\code{TRUE}.}
}
\value{
an object of class \code{\link{feature_test}}.
}
\description{
Performs a feature selection on positioned n-gram data using a Fisher's
permutation test.
}
\details{
Currently implemented criterions:
\itemize{
\item{"\code{ig}" - information gain}
}

Since the procedure involes multiple testing, it is advisable to use one of the avaible
p-value adjustment methods. Such methods can be used directly by specifying the
\code{adjust} parameter.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0
and 1 values.

Features occuring too often and too rarely are considered not informative and may be removed
using the threshold parameter.
}
\examples{
#significant feature
tar_feat1 <- create_feature_target(10, 390, 0, 600)
#significant feature
tar_feat2 <- create_feature_target(9, 391, 1, 599)
#insignificant feature
tar_feat3 <- create_feature_target(198, 202, 300, 300)
test_res <- test_features(tar_feat1[, 1], cbind(tar_feat1[, 2], tar_feat2[, 2], tar_feat3[, 2]))
summary(test_res)
cut(test_res)
}
\references{
Radivojac P, Obradovic Z, Dunker AK, Vucetic S,
\emph{Feature selection filters based on the permutation test} in
Machine Learning: ECML 2004, 15th European
Conference on Machine Learning, Springer, 2004.
}
\seealso{
See \code{\link{criterion_distribution}} for insight on QuiPT.

\code{\link{summary.feature_test}} - summary of results.

\code{\link{cut.feature_test}} - aggregates test results in groups based on feature's
p-value.
}
\keyword{nonparametric}

