% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubgroups.R
\name{getSubgroups}
\alias{getSubgroups}
\title{Retrieve available subgroups for a kingdom of life}
\usage{
getSubgroups(kingdom, db = "refseq")
}
\arguments{
\item{kingdom}{a character string specifying for which kingdom of life subgroups shall be retrieved. See \code{\link{getKingdoms}} for details.}

\item{db}{a character string specifying the database from which the genome shall be retrieved: \code{db = "refseq"}, \code{db = "genbank"}.
Default is \code{db = "refseq"}.}
}
\description{
A short list of available subgroups for a kingdom of life.
}
\examples{
\dontrun{ 
# get possible kigdom names
getKingdoms(db = "refseq")
# retrieve subgroups for vertebrate_mammalian available from refseq
getSubgroups(kingdom = "vertebrate_mammalian", db = "refseq")

# get possible kigdom names
getKingdoms(db = "genbank")
# retrieve subgroups for vertebrate_mammalian available from genbank
getSubgroups(kingdom = "vertebrate_mammalian",db = "genbank")
}
}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{meta.retrieval}}, \code{\link{getGenome}}, \code{\link{getProteome}}, \code{\link{getCDS}}
}

