% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.retrieval.all.R
\name{meta.retrieval.all}
\alias{meta.retrieval.all}
\title{Perform Meta-Genome Retieval of all organisms in all kingdoms of life}
\usage{
meta.retrieval.all(db = "refseq", type = "genome")
}
\arguments{
\item{db}{a character string specifying the database from which the genome shall be retrieved: \code{refseq} or \code{genbank}.}

\item{type}{type of sequences that shall be retrieved. Either \code{genome}, \code{proteome}, or \code{CDS}.}
}
\description{
Download genomes, proteomes, or CDS of individual species of all kingdoms of life.
}
\details{
This function aims to perform bulk retrieval of all genomes of species
for all kingdoms of life.
}
\examples{
\dontrun{
# download all genomes from refseq
meta.retrieval.all(db = "refseq", type = "genome")

# download all vertebrate genomes from genbank
meta.retrieval.all(db = "genbank", type = "genome")

# download all vertebrate genomes from ensemblgenomes
meta.retrieval.all(db = "genbank", type = "ensemblgenomes")
}
}
\author{
Hajk-Georg Drost
}

