% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenome.R
\name{getGenome}
\alias{getGenome}
\title{Genome Retrieval}
\usage{
getGenome(
  db = "refseq",
  organism,
  reference = FALSE,
  release = NULL,
  gunzip = FALSE,
  path = file.path("_ncbi_downloads", "genomes"),
  assembly_type = "toplevel"
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organism}{there are three options to characterize an organism:
\itemize{
\item by \code{scientific name}: e.g. \code{organism = "Homo sapiens"}
\item by \code{database specific accession identifier}: e.g. \code{organism = "GCF_000001405.37"} (= NCBI RefSeq identifier for \code{Homo sapiens})
\item by \code{taxonomic identifier from NCBI Taxonomy}: e.g. \code{organism = "9606"} (= taxid of \code{Homo sapiens})
}}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{gunzip}{a logical value indicating whether or not files should be unzipped.}

\item{path}{a character string specifying the location (a folder) in which
the corresponding genome shall be stored. Default is
\code{path} = \code{file.path("_ncbi_downloads","genomes")}.}

\item{assembly_type}{a character string specifying from which assembly type the genome
shall be retrieved from (ensembl only, else this argument is ignored):
Default is
\code{assembly_type = "toplevel")}.
This will give you all multi-chromosomes (copies of the same chromosome with small variations).
As an example the toplevel fasta genome in human is over 70 GB uncompressed.
To get primary assembly with 1 chromosome variant per chromosome:
\code{assembly_type = "primary_assembly")}.
As an example, the  primary_assembly fasta genome in human is only a few GB uncompressed:}
}
\value{
File path to downloaded genome.
}
\description{
Main genome retrieval function for an organism of interest.
By specifying the scientific name of an organism of interest the
corresponding fasta-file storing the genome of the organism of interest
can be downloaded and stored locally. Genome files can be retrieved from
several databases. In addition, the genome summary statistics for the
retrieved species is stored locally to provide users with
insights regarding the genome assembly quality (see \code{\link{summary_genome}} for details).
This is useful when comparing genomes with large difference in genome assembly qualities.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory '_ncbi_downloads/genomes' to store
the genome of interest as fasta file for future processing.
In case the corresponding fasta file already exists within the
'_ncbi_downloads/genomes' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{

# download the genome of Arabidopsis thaliana from refseq
# and store the corresponding genome file in '_ncbi_downloads/genomes'
file_path <- getGenome( db       = "refseq",
             organism = "Arabidopsis thaliana",
             path = file.path("_ncbi_downloads","genomes"))

Ath_genome <- read_genome(file_path, format = "fasta")


# download the genome of Arabidopsis thaliana from genbank
# and store the corresponding genome file in '_ncbi_downloads/genomes'
file_path <- getGenome( db       = "genbank",
             organism = "Arabidopsis thaliana",
             path = file.path("_ncbi_downloads","genomes"))

Ath_genome <- read_genome(file_path, format = "fasta")
}

}
\seealso{
\code{\link{getGenomeSet}}, \code{\link{getProteome}}, \code{\link{getCDS}},
\code{\link{getGFF}}, \code{\link{getRNA}}, \code{\link{getRepeatMasker}},
\code{\link{getAssemblyStats}}, \code{\link{summary_genome}},
\code{\link{meta.retrieval}}, \code{\link{meta.retrieval.all}}, \code{\link{read_genome}}
}
\author{
Hajk-Georg Drost
}
