% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_SampleFactorLevels.R
\name{bm_SampleFactorLevels}
\alias{bm_SampleFactorLevels}
\alias{bm_SampleFactorLevels.raster}
\alias{bm_SampleFactorLevels.data.frame}
\title{Tool to ensure the sampling of all levels of a factorial variable}
\usage{
bm_SampleFactorLevels(expl.var, mask.out = NULL, mask.in = NULL)
}
\arguments{
\item{expl.var}{a \code{data.frame} or \code{\link[raster:stack]{RasterStack}} object 
containing the explanatory variables (in columns or layers)}

\item{mask.out}{a \code{data.frame} or \code{\link[raster:raster]{raster}} object containing 
the area that has already been sampled (\emph{factor levels within this mask will not be 
sampled})}

\item{mask.in}{a \code{data.frame}, \code{\link[raster:raster]{raster}} or 
\code{\link[raster:stack]{RasterStack}} object containing areas where factor levels are to be 
sampled in priority. \emph{Note that if after having explored these masks, some factor levels 
remain unsampled, they will be sampled in the reference input object \code{expl.var}.}}
}
\value{
A \code{numeric vector} containing point IDs (either cell number for \code{raster*} objects, 
or row number for \code{data.frame}), each refering to a single level of a single factorial 
variable.

In case any factorial variable is found in the input object, \code{NULL} is returned.
}
\description{
This internal \pkg{biomod2} function samples randomly an element of each level of 
all the factorial variables contained in a \code{raster*} or \code{data.frame} object.
}
\details{
The \code{expl.var}, \code{mask.out} and \code{mask.in} parameters must be coherent in terms of 
dimensions :
\itemize{
  \item same number of rows for \code{data.frame} objects
  \item same resolution, projection system and number of cells for \code{raster*} objects 
  \cr \cr
}

If \code{mask.in} contains several masks (either it is a 
\code{\link[raster:stack]{RasterStack}} object or a multi-columns \code{data.frame}), then 
the order of masks / columns matters : they will be considered successively to sample missing 
factor levels. \cr \cr

\itemize{
  \item \code{raster*} masks will be understood as :
  \itemize{
    \item \code{NA} : out of mask
    \item \code{not NA} : in mask
  }
  \item \code{data.frame} masks will be understood as :
  \itemize{
    \item \code{FALSE} : out of mask
    \item \code{TRUE} : in mask
  }
}
}
\examples{

library(raster)

## Create raster data
ras.1 <- ras.2 <- mask.out <- raster(nrows = 10, ncols = 10)
ras.1[] <- as.factor(rep(c(1, 2, 3, 4, 5), each = 20))
ras.2[] <- rnorm(100)
stk <- stack(ras.1, ras.2)
names(stk) <- c("varFact", "varNorm")

## define a mask for already sampled points
mask.out[1:40] <- 1

## define a list of masks where we want to sample in priority
mask.in <- list(ras.1, ras.1)
mask.in[[1]][1:80] <- NA ## only level 5 should be sampled in this mask
mask.in[[1]][21:80] <- NA ## only levels 1 and 5 should be sampled in this mask

## Sample all factor levels
samp1 <- bm_SampleFactorLevels(expl.var = stk, mask.out = mask.out)
samp2 <- bm_SampleFactorLevels(expl.var = stk, mask.in = mask.in)
samp3 <- bm_SampleFactorLevels(expl.var = stk, mask.out = mask.out, mask.in = mask.in)


}
\seealso{
\code{\link{bm_PseudoAbsences}}, \code{\link{bm_RunModelsLoop}}, 
\code{\link{BIOMOD_Modeling}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secundary functions}
