% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_5.R
\name{predict2.em}
\alias{predict2.em}
\alias{predict2.biomod2_ensemble_model.RasterStack}
\alias{predict2.biomod2_ensemble_model.data.frame}
\alias{predict2.EMmean_biomod2_model.RasterStack}
\alias{predict2.EMmean_biomod2_model.data.frame}
\alias{predict2.EMmedian_biomod2_model.RasterStack}
\alias{predict2.EMmedian_biomod2_model.data.frame}
\alias{predict2.EMcv_biomod2_model.RasterStack}
\alias{predict2.EMcv_biomod2_model.data.frame}
\alias{predict2.EMci_biomod2_model.RasterStack}
\alias{predict2.EMci_biomod2_model.data.frame}
\alias{predict2.EMca_biomod2_model.RasterStack}
\alias{predict2.EMca_biomod2_model.data.frame}
\alias{predict2.EMwmean_biomod2_model.RasterStack}
\alias{predict2.EMwmean_biomod2_model.data.frame}
\alias{predict2,biomod2_ensemble_model,RasterStack-method}
\alias{predict2,biomod2_ensemble_model,data.frame-method}
\alias{predict2,EMmean_biomod2_model,RasterStack-method}
\alias{predict2,EMmean_biomod2_model,data.frame-method}
\alias{predict2,EMmedian_biomod2_model,RasterStack-method}
\alias{predict2,EMmedian_biomod2_model,data.frame-method}
\alias{predict2,EMcv_biomod2_model,RasterStack-method}
\alias{predict2,EMcv_biomod2_model,data.frame-method}
\alias{predict2,EMci_biomod2_model,RasterStack-method}
\alias{predict2,EMci_biomod2_model,data.frame-method}
\alias{predict2,EMca_biomod2_model,RasterStack-method}
\alias{predict2,EMca_biomod2_model,data.frame-method}
\alias{predict2,EMwmean_biomod2_model,RasterStack-method}
\alias{predict2,EMwmean_biomod2_model,data.frame-method}
\title{Functions to get predictions from \code{\link{biomod2_ensemble_model}} objects}
\usage{
\S4method{predict2}{biomod2_ensemble_model,RasterStack}(
  object,
  newdata,
  predfun,
  seedval = NULL,
  data_as_formal_predictions = FALSE,
  ...
)

\S4method{predict2}{biomod2_ensemble_model,data.frame}(
  object,
  newdata,
  predfun,
  seedval = NULL,
  data_as_formal_predictions = FALSE,
  ...
)

\S4method{predict2}{EMmean_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMmean_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{EMmedian_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMmedian_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{EMcv_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMcv_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{EMci_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMci_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{EMca_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMca_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{EMwmean_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{EMwmean_biomod2_model,data.frame}(object, newdata, ...)
}
\arguments{
\item{object}{a \code{\link{biomod2_ensemble_model}} object}

\item{newdata}{a \code{data.frame} or \code{\link[raster:stack]{RasterStack}} object 
containing data for new predictions}

\item{predfun}{a \code{function}, generated by the \code{predict2} method
  specific to each \code{\link{biomod2_model}} subclass and used within the
  generic \code{predict2.biomod2_model.RasterStack} or
\code{predict2.biomod2_model.data.frame} to do the prediction}

\item{seedval}{(\emph{optional, default} \code{NULL}) \cr An \code{integer}
value corresponding to the new seed value to be set}

\item{data_as_formal_predictions}{(\emph{optional, default} \code{FALSE}). A
\code{boolean} describing whether \code{newdata} is given as raw environmental 
data (\code{FALSE}) or as formal predictions of the individual models 
used to build the ensemble model (\code{TRUE}).}

\item{\ldots}{(\emph{optional})}
}
\description{
This function allows the user to predict single models from 
\code{\link{biomod2_ensemble_model}} on (new) explanatory variables.
}
\seealso{
\code{\link{biomod2_ensemble_model}}

Other Toolbox functions: 
\code{\link{getters.bm}},
\code{\link{getters.out}},
\code{\link{load_stored_object}()},
\code{\link{predict.bm}},
\code{\link{predict.em}},
\code{\link{predict2.bm}}
}
\author{
Remi Patin
}
\concept{Toolbox functions}
\keyword{internal}
