% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_CVnnet.R
\name{bm_CVnnet}
\alias{bm_CVnnet}
\title{Cross-validation for Neural Networks}
\usage{
bm_CVnnet(
  Input,
  Target,
  size = c(2, 4, 6, 8),
  decay = c(0.001, 0.01, 0.05, 0.1),
  maxit = 200,
  nbCV = 5,
  weights = NULL,
  seedval = 555
)
}
\arguments{
\item{Input}{complete dataset with explanatory variables}

\item{Target}{calibration dataset with observed presence / absence}

\item{size}{(see parameter \code{ANN$size} in \code{\link{BIOMOD_ModelingOptions}})}

\item{decay}{(see parameter \code{ANN$decay} in \code{\link{BIOMOD_ModelingOptions}})}

\item{maxit}{(see parameter \code{ANN$maxit} in \code{\link{BIOMOD_ModelingOptions}})}

\item{nbCV}{(see parameter \code{ANN$nbCV} in \code{\link{BIOMOD_ModelingOptions}})}

\item{weights}{a \code{vector} of \code{numeric} values corresponding to weights over 
calibration lines}

\item{seedval}{an \code{integer} value corresponding to the new seed value to be set}
}
\value{
A \code{data.frame} containing the following elements :
\itemize{
  \item{\code{Size} : }{the size}
  \item{\code{Decay} : }{the decay value}
  \item{\code{AUC} : }{the corresponding Area Under Curve}
}
}
\description{
This internal \pkg{biomod2} function allows the user to compute cross-validation 
for neural networks in ANN model (see \code{\link[nnet]{nnet}} and 
\code{\link{BIOMOD_Modeling}}).
}
\seealso{
\code{\link[nnet]{nnet}}, \code{\link[pROC]{auc}}, \code{\link[pROC]{roc}}, 
\code{\link{BIOMOD_ModelingOptions}}, \code{\link{BIOMOD_Modeling}}, 
\code{\link{bm_SampleBinaryVector}}, \code{\link{bm_RunModelsLoop}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secundary functions}
\keyword{"neural}
\keyword{cross-validation}
\keyword{networks"}
