% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_dbscan.R
\name{nhclu_dbscan}
\alias{nhclu_dbscan}
\title{dbscan clustering}
\usage{
nhclu_dbscan(
  dissimilarity,
  index = names(dissimilarity)[3],
  minPts = NULL,
  eps = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{minPts}{a \code{numeric} value or a vector of \code{numeric} values
specifying the minPts argument of \link[dbscan:dbscan]{dbscan::dbscan()}).
minPts is the minimum number of points to form a dense region. By default,
it is set to the natural logarithm of the number of sites in
\code{dissimilarity}. See details for guidance on choosing this parameter.}

\item{eps}{a \code{numeric} value or a vector of \code{numeric} values specifying the
eps argument of \link[dbscan:dbscan]{dbscan::dbscan()}). eps specifies how
similar points should be to each other to be considered a part of a cluster.
See details for guidance on choosing this parameter.}

\item{plot}{a \code{boolean} indicating if the  k-nearest neighbor distance plot
should be plotted.}

\item{...}{you can add here further arguments to be passed to \code{dbscan()}
(see \link[dbscan:dbscan]{dbscan::dbscan()})}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \verb{character string} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}
}
\description{
This function performs non hierarchical clustering on the basis of
dissimilarity with Density-based Spatial Clustering of Applications with
Noise (DBSCAN)
}
\details{
The dbscan (Density-based spatial clustering of
applications with noise) clustering algorithm clusters points on the basis
of the density of neighbours around each data points. It necessitates two
main arguments, \code{minPts}, which stands for the minimum number of points to
identify a core, and \code{eps}, which is the radius to find neighbors.
\code{minPts} and \code{eps} should be defined by the user, which is not
straightforward.
We recommend reading the help in \link[dbscan:dbscan]{dbscan::dbscan()})
to learn how to set these arguments, as well as the paper
\insertCite{Hahsler2019}{bioregion}. Note that clusters with a value of 0
are points which were deemed as noise by the algorithm.

By default the function will select values for \code{minPts} and \code{eps}. However,
these values can be inadequate and the users is advised to tune these values
by running the function multiple times.

\strong{Choosing minPts:} how many points should be necessary to make a cluster?
i.e., what is the minimum number of sites you expect in a bioregion? Set a
value sufficiently large for your dataset and your expectations.

\strong{Choosing eps:} how similar should sites be in a cluster?  If \code{eps} is
too small, then a majority of points will be considered too distinct and
will not be clustered at all (i.e., considered as noise)? If the value is
too high, then clusters will merge together.
The value of \code{eps} depends on the \code{minPts} argument, and the literature
recommends to choose \code{eps} by identifying a knee in the k-nearest neighbor
distance plot. By default
the function will try to automatically find a knee in that curve, but the
result is uncertain, and so the user should inspect the graph and modify
\code{dbscan_eps} accordingly.To explore eps values, follow the
recommendation by the function when you launch it a first time without
defining \code{eps}. Then, adjust depending on your clustering results.
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_dbscan(dissim, index = "Simpson")
clust2 <- nhclu_dbscan(dissim, index = "Simpson", eps = 0.2)
clust3 <- nhclu_dbscan(dissim, index = "Simpson", minPts = c(5, 10, 15, 20),
     eps = c(.1, .15, .2, .25, .3))

}
\seealso{
\link{hclu_optics}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
