% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{convert_prefix}
\alias{convert_prefix}
\title{Convert between metric prefixes.}
\usage{
convert_prefix(x, from, to)
}
\arguments{
\item{x}{The value to convert.}

\item{from}{A string containing the prefixed unit A.}

\item{to}{A string containing the prefixed unit B.}
}
\value{
The converted value.
}
\description{
A convenience wrapper around \code{\link[=calc_factor_prefix]{calc_factor_prefix()}}.
}
\details{
Convert, e.g. "kg" to "µg". You can convert ".g", ".l", ".mol", ".m^3"
(cubic metres), where "." symbolises a metric prefix:

For g, l and mol: d (deci), c (centi), m (milli), µ (micro), n (nano),
p (pico) and f (femto).

For g you might use k (kilo) as well.

For m^3 (cubic metres) you may only use: d (deci), c (centi) and m (milli).
}
\examples{
convert_prefix(x = 2, from = "ng", to = "kg")
convert_prefix(x = 2, from = "dm^3", to = "cm^3")
convert_prefix(x = 2, from = "fl", to = "pl")
convert_prefix(x = 2, from = "pmol", to = "nmol")

}
\seealso{
Other conversion functions: \code{\link{calc_factor_conc}},
  \code{\link{calc_factor_prefix}},
  \code{\link{convert_conc}}
}
