% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_SAC.R
\name{compare_SAC}
\alias{compare_SAC}
\title{Comparative plots of species accumulation curves}
\usage{
compare_SAC(SAC_selected_sites, element_1, element_2, col_mean1 = "blue",
            col_CI1 = "lightblue", col_mean2 = "gray15",
            col_CI2 = "gray65", lty1 = 1, lty2 = 2,
            alpha_mean = 0.9, alpha_CI = 0.3,
            xlab = "Number of sites", ylab = "Species",
            line_for_multiple = TRUE, add_legend = TRUE, ...)
}
\arguments{
\item{SAC_selected_sites}{nested list of "\code{specaccum}" objects obtained
with function \code{\link{selected_sites_SAC}}.}

\item{element_1}{(numeric or character) index of position or character
indicator of the first element (type of selection) in
\code{SAC_selected_sites} to be plotted. Character options are: "random",
"E", "G", "EG".}

\item{element_2}{(numeric or character) index of position or character
indicator of the second element (type of selection) in
\code{SAC_selected_sites} to be plotted. Character options are: "random",
"E", "G", "EG".}

\item{col_mean1}{(character) color for mean value of curve in
\code{element_1}; default = "blue".}

\item{col_CI1}{(character) color for confidence interval region for the
curve in \code{element_1}; default = "lightblue".}

\item{col_mean2}{(character) color for mean value of curve in
\code{element_2}; default = "gray15".}

\item{col_CI2}{(character) color for confidence interval region for the
curve in \code{element_2}; default = "gray65".}

\item{lty1}{type of line for \code{element_1}. See lty in \code{\link{par}}.}

\item{lty2}{type of line for \code{element_2}. See lty in \code{\link{par}}.}

\item{alpha_mean}{(numeric) alpha level for line representing the mean,
values from 0 to 1; default = 0.9. Values close to 0 increase transparency.}

\item{alpha_CI}{(numeric) alpha level for the region representing the
confidence interval; default = 0.3.}

\item{xlab}{(character) label for x-axis of plot; default = "Number of
sites".}

\item{ylab}{(character) label for y-axis of plot; default = "Species".}

\item{line_for_multiple}{(logical) whether to plot SACs only as lines when
multiple objects are in one or more of the internal lists in
\code{SAC_selected_sites}. Default = TRUE.}

\item{add_legend}{(logical) whether to add default legend to plot; default =
TRUE.}

\item{...}{other arguments to be passed to plot method for objects of class
"\code{specaccum}".}
}
\value{
A comparative plot of two species "\code{specaccum}" objects done based on
what is defined in \code{element_1} and  \code{element_2}.
}
\description{
creates comparative plots of two species accumulation curves
from information contained in lists obtained with the function
\code{\link{selected_sites_SAC}}.
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")

SACs <- selected_sites_SAC(PAM_subset = sub_pam_all, selection_type = "all")

compare_SAC(SAC_selected_sites = SACs, element_1 = 1, element_2 = 2)
}
