% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selected_sites_DI.R
\name{selected_sites_DI}
\alias{selected_sites_DI}
\title{Dissimilarity indices from PAM_subset}
\usage{
selected_sites_DI(PAM_subset, selection_type = "all", method = "jaccard",
                  verbose = TRUE, ...)
}
\arguments{
\item{PAM_subset}{object of class PAM_subset obtained using the function
\code{\link{subset_PAM}}.}

\item{selection_type}{type of selection to be considered when creating
dissimilarity matrices for elements in \code{PAM_subset}. Options are:
"all", "random", "E", "G", and "EG". The default, "all", uses all selection
types present in \code{PAM_subset}.}

\item{method}{(character) dissimilarity index to be passed to function
\code{\link[vegan]{vegdist}}. Default = "jaccard". See details.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}

\item{...}{other arguments to be passed to function
\code{\link[vegan]{vegdist}}.}
}
\value{
A list containing:
\itemize{
\item Dissimilarity matrices for all PAMs reduced based on distinct sets of
selected sites.
\item A matrix summarizing incidences from all sets of selected sites.
\item A dissimilarity matrix for the summary of incidences for all sets of
selected sites.
\item The result of clustering sets of selected sites based on dissimilarities.
}
}
\description{
Computes dissimilarity indices for each set of selected
sites contained in elements of \code{PAM_subset} that contain information of
species incidence (presence-absence). Calculations are done also among sets
of selected sites.
}
\details{
Important details about the process performed to compute dissimilarity
indices can be seen in the documentation of \code{\link[vegan]{vegdist}}.
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")

# Calculating dissimilarities
DI_sel <- selected_sites_DI(sub_pam_all)
}
