% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_blocks.R
\name{make_blocks}
\alias{make_blocks}
\title{Creates a block-like regionalization of environmental space}
\usage{
make_blocks(master_matrix, variable_1, variable_2, n_cols, n_rows = NULL,
            block_type = "equal_area")
}
\arguments{
\item{master_matrix}{object derived from function
\code{\link{prepare_master_matrix}}.}

\item{variable_1}{(character or numeric) name or position of the first
variable (x-axis) to be used to create blocks.}

\item{variable_2}{(character or numeric) name or position of the second
variable (y-axis) to be used to create blocks (must be different from the
first one).}

\item{n_cols}{(numeric) number of columns of a grid used to creates blocks
and split the bi-dimensional space.}

\item{n_rows}{(numeric) number of rows of a grid used to creates blocks and
split the bi-dimensional space. If NULL, the default, \code{n_rows = n_cols}.}

\item{block_type}{(character) type of blocks to be use for dividing
the bi-dimensional space. Two options are available: "equal_area" and
"equal_points". Default = "equal_area".}
}
\value{
An S3 object of class master_matrix, containing the same elements found in a
master_matrix object, with an additional column on the master_matrix
data.frame containing block identifiers. If the element preselected_sites is
not NULL in master_matrix, blocks are also assigned to this sites.
}
\description{
Divides a two-dimensional cloud of points in blocks according
to a user-defined number of rows and columns. This is applied to the element
master_matrix and, if not NULL, to preselected_sites.
}
\details{
For block_type, option "equal_area" generates blocks of the same size. The
other option ("equal_points"), generates blocks containing the same number
of points, which generally results in blocks of different sizes.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

# Creating blocks
m_blocks <- make_blocks(m_matrix, variable_1 = "PC1",
                        variable_2 = "PC2", n_cols = 10, n_rows = 10,
                        block_type = "equal_area")
unique(m_blocks$data_matrix$Block)
}
