% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_project_to_one_mode.R
\name{project_to_one_mode}
\alias{project_to_one_mode}
\title{Create a one-mode projection of a two mode graph}
\usage{
project_to_one_mode(adj_mat, mode = c("rows", "columns"))
}
\arguments{
\item{adj_mat}{Sparse matrix of class dgCMatrix}

\item{mode}{Mode to return. Defaults to projecting by rows.}
}
\value{
A double or complex matrix, with appropriate dimnames taken from x and y.
}
\description{
Create a one-mode projection of a two mode graph. Converts a rectangular matrix to a square one by taking the cross product of the input matrix. The edge weights in the resulting matrix are equal to the number of transitive ties of each node in the input matrix.
}
\examples{
#make matrix
   my_matrix <- sparseMatrix(i = c(1, 1, 2, 3, 4, 4, 5, 6, 7, 7), 
       j = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), x = 1
   )
#project to one mode
   project_to_one_mode(adj_mat = my_matrix, mode = "rows")
}
\keyword{dgCMatrix}
\keyword{matrix}
