% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bf.R
\encoding{UTF-8}
\name{plot_bf}
\alias{plot_bf}
\title{Plots summary of Bayes Factors calculations}
\usage{
plot_bf(m.liks, thr = 2, dir = c("vertical", "horizontal"),
  col = c("#d32f23", "#2e86ab", "#000000"), col.thr = c("#a6e1fa"),
  ax.lab = "log(BF)", main = "", rank = TRUE, dec = TRUE,
  group.pattern = NULL, cex = c(1.2, 1, 1), mod.lab = NULL,
  srt.lab = 0, adj.lab = 0, space = c(1.2, 0.8))
}
\arguments{
\item{m.liks}{matrix of marginal likelihoods (see details)}

\item{thr}{value of BF threshold for model selection (default is 2), Several thresholds can be given in the form of a vector}

\item{dir}{string giving the direction of the plot ("vertical", "horizontal")}

\item{col}{color of the lines and dots. Could be of size one or more. The first element applies to the best model, the second to the ones below thr[1] and so on...}

\item{col.thr}{color for the threshold area (must be at the sime length as thr)}

\item{ax.lab}{label of the axis.}

\item{main}{an overall title for the plot}

\item{rank}{logical: should models be ranked by BF scores? (default is TRUE)}

\item{dec}{logical: should models be displayed in decreasing order? (default is TRUE)}

\item{group.pattern}{Regular expression given a pattern to be matched in names(m.liks). The values matching that pattern will be grouped in the plot}

\item{cex}{size of the dots and width of the lines. Could be of size one or more. The first element applies to the best model, the second to the ones below thr[1] and so on...}

\item{mod.lab}{name of the models. If mod.lab = NULL the names of m.liks are used}

\item{srt.lab, adj.lab}{rotation and justification of model names, see srt and adj in \code{\link[graphics]{par}}}

\item{space}{only evaluated if group.pattern != NULL, numeric(2) indicating the space between groups and the space between members of the same groups}
}
\description{
Lolipop plot representing values of BF (Bayes Factor) scores for different models
}
\examples{
## Fake marginal likelihood data
m.liks <- c(20 ,33, 56, 51, 55, 12)
names(m.liks) <- c("MBM-VBM", "MBM-VWN", "MBM-VOU", "MOU-VBM", "MOU-VWN", "MOU-VOU")

#Does not go well with default margin sizes
oldmar <- par()$mar
par(mar = c(5,1,4,6))
plot_bf(m.liks)
plot_bf(m.liks, thr = c(2,6), col.thr = c("#a2c5ac", "#ade1e5"),
 col = c("#d32f23", "#468189","#2e86ab","#000000"), cex = c(1.2,1,0.8,0.8))
plot_bf(m.liks, group.pattern = "MBM", rank = FALSE)
plot_bf(m.liks, group.pattern = "MOU", rank = TRUE)
plot_bf(m.liks, group.pattern = c("VWN", "VOU", "VBM"), rank = TRUE)
par(mar = c(6,5,1,2))
plot_bf(m.liks, dir = "horizontal", srt.lab = -60, adj.lab = c(0,0.8))
par(mar = oldmar)
}
\author{
Theo Gaboriau
}
