% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_rotate.R
\name{bm_rotate}
\alias{bm_rotate}
\title{Rotate bitmaps 0, 90, 180, or 270 degrees}
\usage{
bm_rotate(bm_object, angle = 0, clockwise = TRUE)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{angle}{Angle to rotate bitmap by.}

\item{clockwise}{If \code{TRUE} rotate bitmaps clockwise.
Note Unicode's convention is to rotate glyphs clockwise
i.e. the top of the "BLACK CHESS PAWN ROTATED NINETY DEGREES" glyph points right.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_rotate()} losslessly rotates bitmaps by 0, 90, 180, or 270 degrees.
If \code{90} or \code{270} degrees are indicated the width and height of the bitmap will be flipped.
}
\examples{
  # as_bm_list.character()
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  capital_r <- font[[str2ucp("R")]]
  print(bm_rotate(capital_r, 90), px = px_ascii)
  print(bm_rotate(capital_r, 180), px = px_ascii)
  print(bm_rotate(capital_r, 270), px = px_ascii)
  print(bm_rotate(capital_r, 90, clockwise = FALSE), px = px_ascii)

}
\seealso{
\code{\link[=bm_distort]{bm_distort()}} can do other (distorted) rotations by careful
use of its \code{vp} \code{\link[grid:viewport]{grid::viewport()}} argument.
\code{\link[=bm_flip]{bm_flip()}} with \code{direction} "both" and \code{in_place} \code{TRUE} can
rotate glyphs 180 degrees in place.
}
