% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_pad.R
\name{bm_pad}
\alias{bm_pad}
\title{Adjust bitmap padding lengths}
\usage{
bm_pad(
  bm_object,
  value = 0L,
  type = c("exact", "extend", "trim"),
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL
)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{value}{Integer value for the new pixels.}

\item{type}{Either "exact", `"extend", or "trim".
"exact" makes sure the padding is exactly the indicated amount,
"extend" does not trim any padding if existing padding is more than the indicated amount,
and "trim" does not extend any padding if existing padding is less than the indicated amount.}

\item{sides}{If not \code{NULL} then an integer vector indicating the desired
number of pixels of padding on all four sides.
If the integer vector is of length one it indicates the number of pixels for all four sides.
If of length two gives first the number for the vertical sides and then the horizontal sides.
If of length three gives the number of pixels for top, the horizontal sides, and then bottom sides.
If of length four gives the number of pixels for top, right, bottom, and then left sides.
This is the same scheme as used by the CSS padding and margin properties.}

\item{top}{Desired number of pixels of padding on the top.}

\item{right}{Desired number of pixels of padding on the right.}

\item{bottom}{Desired number of pixels of padding on the bottom.}

\item{left}{Desired number of pixels of padding on the left.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_pad()} adjusts bitmap padding lengths.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r, px = c(".", "#"))
 capital_r_padded <- bm_pad(capital_r, sides = 2L)
 print(capital_r_padded, px = c(".", "#"))
}
\seealso{
\code{\link[=bm_extend]{bm_extend()}}, \code{\link[=bm_resize]{bm_resize()}}, and \code{\link[=bm_trim]{bm_trim()}}
}
