% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_overlay.R
\name{bm_overlay}
\alias{bm_overlay}
\title{Merge bitmaps by overlaying one over another}
\usage{
bm_overlay(
  bm_object,
  over = NULL,
  under = NULL,
  hjust = "center-left",
  vjust = "center-top"
)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{over}{A 'bm_bitmap()' object to overlay
over the \code{bm_object} bitmap(s).
Only one of \code{over} or \code{under} may be set.}

\item{under}{A 'bm_bitmap()' object which will be overlaid
by the \code{bm_object} bitmap(s).
Only one of \code{over} or \code{under} may be set.}

\item{hjust}{One of "left", "center-left", "center-right", "right".
"center-left" and "center-right" will attempt to
place in "center" if possible but if not possible will bias
it one pixel left or right respectively.
"centre", "center", and "centre-left" are aliases for "center-left".
"centre-right" is an alias for "center-right".}

\item{vjust}{One of "bottom", "center-bottom", "center-top", "top".
"center-bottom" and "center-top" will attempt to
place in "center" if possible but if not possible will bias
it one pixel down or up respectively.
"centre", "center", and "centre-top" are aliases for "center-top".
"centre-bottom" is an alias for "center-bottom".}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_overlay()} merges bitmaps by overlaying a bitmap over another.
}
\details{
If necessary bitmaps will be extended by \code{bm_extend()} such that
they are the same size.  Then the non-zero pixels of the \dQuote{over}
bitmap will be inserted into the \dQuote{under} bitmap.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  grave <- font[[str2ucp("`")]]
  a <- font[[str2ucp("a")]]
  a_grave <- bm_overlay(a, over = grave)
  print(a_grave, px = px_ascii)

  # Can also instead specify the under glyph as a named argument
  a_grave2 <- bm_overlay(grave, under = a)
  print(a_grave2, px = px_ascii)
}
