% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivquant.r
\name{bivquant}
\alias{bivquant}
\title{Bivariate Quantiles}
\usage{
bivquant(y, alphaseq = NULL, tau = NULL, transformed = FALSE)
}
\arguments{
\item{y}{the responses in a matrix or data frame with 2 columns and rows equal to the number of observations.}

\item{alphaseq}{The angles along which the quantile should be computed, can be a vector. If not specified, quantiles will
will be computed for a equidistant grid from 0 to \eqn{\pi/2} of length 10 is used.}

\item{tau}{The quantile level. If not specified, the median, \eqn{\tau=0.5} will be computed.}

\item{transformed}{Default is FALSE specifying that quantiles on the original scale are returned. If TRUE, quantiles on the
unit square are returned in addition.}
}
\value{
an object of class \code{bivquant}.
}
\description{
This function fits the empirical bivariate quantiles based on the CDF (cumulative distrubtion function). We use 
linear programming. Currently, the solver is \code{\link{lp}} from the package
\code{lpSolve}
}
\details{
The function imitates rotation around (1,1) in the transformed
coordinate system and thus allows to estimate the marginal quantiles.
}
\examples{
require("MASS")
require("mvtnorm")
set.seed(42)

tauseq <- seq(0.1,0.9,by=0.1) #quantile levels

alphas <- seq(0*pi/32,16*pi/32,by=0.5*pi/32) #grid of angles
n <- 50 #sample size

#generate bivariate data
mu <- c(6, 10)
#correlated responses
rho <- 0.5
Sigma <- matrix(c(
    1.0, rho,
    rho, 1.0
  ),
  ncol=2, byrow=TRUE)

X <- rmvnorm(n, mu, Sigma)
bivqu <- bivquant(X,alpha=alphas,tau=tauseq)
plot(bivqu, pch=20,col="grey")


#bigger n
set.seed(123)
n <- 100


X <- dgp_cop(n, family="clayton", margins=c("norm", "norm"),
		 paramMargins=list(list(mean = 4, sd = 1), list(mean = 4, sd = 5)),
		 rho=1.75)


bivqu <- bivquant(X,alpha=alphas,tau=tauseq)
plot(bivqu, pch=20,col="grey")
}
\references{
Nadja Klein and Thomas Kneib (2019). Directional Bivariate Quantiles - A Robust Approach based on the Cumulative Distribution Function. To appear in Advances in Statistical Analysis (AStA)
}
\seealso{
\code{\link{lp}}.
}
\author{
Nadja Klein.
}
