% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomqu.r
\name{geomqu2d_norm2}
\alias{geomqu2d_norm2}
\title{On Affine Equivariant Multivariate Quantiles}
\usage{
geomqu2d_norm2(data, probs, alpha, k = 8)
}
\arguments{
\item{data}{must be a (n,2) matrix of observations.}

\item{probs}{vector of probs which is used to calculate the us}

\item{alpha}{missing or a vector of length 3 with distict values form 1 to n}

\item{k}{number of us per prob}
}
\description{
This function fits empirical bivariate quantiles as proposed by  Chakraborty, B. (2001).
 2 dimensional data and with p=2
}
\examples{
require("MASS")
require("mvtnorm")
set.seed(42)
n <- 50
mu <- c(6, 10)
#correlated responses
rho <- 0.5
Sigma <- matrix(c(
    1.0, rho,
    rho, 1.0
  ),
  ncol=2, byrow=TRUE)

X <- rmvnorm(n, mu, Sigma)
result <- geomqu2d_norm2(X, probs=c(0.8,0.9), k=8)
plot(result)

#now independent responses
rho <- 0.0
Sigma <- matrix(c(
    1.0, rho,
    rho, 1.0
  ),
  ncol=2, byrow=TRUE)

X <- rmvnorm(n, mu, Sigma)
result <- geomqu2d_norm2(X, probs=c(0.8,0.9), k=8)
plot(result)

#now some non-normal data
X <- dgp_cop(n, family="clayton", margins=c("norm", "norm"),
		 paramMargins=list(list(mean = 4, sd = 1), list(mean = 4, sd = 5)),
		 rho=1.75)
result <- geomqu2d_norm2(X, probs=c(0.8,0.9), k=8)
plot(result)

}
\references{
Chakraborty, B. (2001). On affine equivariant multivariate quantiles. 
\emph{Annals of the Institute of Statistical Mathematics}, \bold{53}, 380--403.
}
\seealso{
\code{\link{geomqu}} for details.
}
\author{
Nadja Klein.
}
