% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rcpp_row_quantile}
\alias{rcpp_row_quantile}
\title{Row-wise quantile of a matrix}
\usage{
rcpp_row_quantile(data, q)
}
\arguments{
\item{data}{Numeric matrix whose row quantiles are wanted.}

\item{q}{Probability with value in [0,1]}
}
\value{
A vector of length \code{nrows(data)}, where each element represents
  row quantile.
}
\description{
This is a C++ speed-optimized version. It is equivalent to R version
\code{quantile(data, q, na.rm = TRUE)}
}
\author{
Viliam Simko
}

