% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Calendar}
\alias{Calendar}
\title{Creates a calendar}
\usage{
Calendar(holidays = integer(0), start.date = "1970-01-01",
  end.date = "2071-01-01", name = NULL, weekdays = NULL, dib = NULL,
  adjust.from = adjust.next, adjust.to = adjust.previous)
}
\arguments{
\item{holidays}{a vector of Dates which contains the holidays}

\item{start.date}{the date which the calendar starts}

\item{end.date}{the date which the calendar ends}

\item{name}{calendar's name}

\item{weekdays}{a character vector which defines the weekdays to be used as
non-working days (defaults to \code{NULL} which represents an actual
calendar). It accepts: \code{sunday}, \code{monday}, \code{thuesday},
\code{wednesday}, \code{thursday}, \code{friday}, \code{saturday}.
Defining the weekend as nonworking days is \code{weekdays=c("saturday", "sunday")}.}

\item{dib}{a single numeric variable which indicates the amount of days
within a year (\code{dib} stands for days in base).}

\item{adjust.from}{is a function to be used with the \code{bizdays}'s \code{from} argument.
That function adjusts the argument if it is a nonworking day according to calendar.}

\item{adjust.to}{is a function to be used with the \code{bizdays}'s \code{to} argument.
See also \code{adjust.from}.}
}
\description{
The \code{Calendar} stores all information necessary to compute business days.
This works like a helper class for many of \code{bizdays}' methods.
}
\details{
The arguments \code{start.date} and \code{end.date} can be set but once \code{holidays}
is set, \code{start.date} is defined to \code{min(holidays)} and \code{end.date} to
\code{max(holidays)}.

\code{weekdays} is controversial but it is only a sequence of nonworking weekdays.
In the great majority of situations it refers to the weekend but it is also possible defining
it differently.
\code{weekdays} accepts a \code{character} sequence with lower case weekdays (
\code{sunday}, \code{monday}, \code{thuesday}, \code{wednesday}, \code{thursday},
\code{friday}, \code{saturday}).
This argument defaults to \code{NULL} because the default intended behavior for
\code{Calendar} returns an \emph{actual} calendar, so calling \code{Calendar(dib=365)}
returns a \emph{actual/365} calendar and \code{Calendar(dib=360)} and \emph{actual/360}
(for more calendars see \href{http://en.wikipedia.org/wiki/Day_count_convention}{Day Count Convention})
To define the weekend as the nonworking weekdays one could simply
use \code{weekdays=c("saturday", "sunday")}.

\code{dib} reffers to \emph{days in base} and represents the amount of days within a year.
That is necessary for defining Day Count Conventions and for accounting annualized periods
(see \code{\link{bizyears}}).

The arguments \code{adjust.from} and \code{adjust.to} are used to adjust \code{bizdays}' arguments
\code{from} and \code{to}, respectively.
These arguments need to be adjusted when nonworking days are provided.
The default behavior, setting \code{adjust.from=adjust.previous} and \code{adjust.to=adjust.next},
works like Excel's function NETWORKDAYS, since that is fairly used by a great number of practitioners.

\code{Calendar} doesn't have to be named, but it helps identifying the calendars once many are instantiated.
You name a \code{Calendar} by setting the argument \code{name}.
}
\examples{
# holidays has iso-formated dates
data(holidaysANBIMA)
cal <- Calendar(name="ANBIMA", holidays=holidaysANBIMA,
                weekdays=c("saturday", "sunday"), dib=252)
# ACTUAL calendar
cal <- Calendar(name="Actual", dib=365)
# unnamed calendars have NULL names
cal <- Calendar(start.date="1976-07-12", end.date="2013-10-28")
is.null(cal$name) # TRUE
}

