% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calendar.R
\name{bizyearse}
\alias{bizyearse}
\title{Business days and current days equivalence in years}
\usage{
bizyearse(dates, curd, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{dates}{the initial dates}

\item{curd}{the amount of current days}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{numeric} objects representing the amount of business days in years.
}
\description{
\code{bizyearse} is a counterparty of \code{bizdayse} which returns the
amount of business days in years.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\section{Recycle rule}{


These arguments handle the recycle rule so a vector of dates and a vector of
numbers can be provided and once those vectors differs in length the recycle
rule is applied.
}
\examples{
data(holidaysANBIMA)
cal <- Calendar(holidaysANBIMA, weekdays=c("saturday", "sunday"), dib=252)
bizyearse("2013-01-02", 3, cal)
}
\seealso{
\code{\link{bizdayse}} for business days.
}

