% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_funs.R
\name{comb_bkmrfits}
\alias{comb_bkmrfits}
\title{Combine multiple BKMR chains}
\usage{
comb_bkmrfits(fitkm.list, burnin = 0, reorder = TRUE)
}
\arguments{
\item{fitkm.list}{output from kmbayes_par}

\item{burnin}{add in custom burnin (number of burnin iterations per chain)}

\item{reorder}{ensures that the first half of the combined chain contains
only the first half of each individual chain - this allows unaltered use
of standard functions from bkmr package, which automatically trims the first
half of the iterations. This can be used for posterior summaries, but
certain diagnostics may not work well (autocorrelation, effective sample size)
so the diagnostics should be done on the individual chains
#' @param ... arguments to \code{\link[bkmrhat]{as.mcmc.bkmrfit}}}
}
\value{
a \code{bkmrplusfit} object, which inherits from \code{bkmrfit}
(from the \code{\link[bkmr]{kmbayes}} function)
with multiple chains combined into a single object and additional parameters
given by \code{chain} and \code{iters}, which index the specific chains and
iterations for each posterior sample in the \code{bkmrplusfit} object
}
\description{
Combine multiple chains comprising BKMR fits at different starting
values.
}
\details{
Chains are not combined fully sequentially
}
\examples{
\donttest{
# following example from https://jenfb.github.io/bkmr/overview.html
set.seed(111)
library(bkmr)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)
Sys.setenv(R_FUTURE_SUPPORTSMULTICORE_UNSTABLE="quiet")
future::plan(strategy = future::multiprocess)
# run 4 parallel Markov chains
fitkm.list <- kmbayes_parallel(nchains=4, y = y, Z = Z, X = X, iter = 5000,
  verbose = FALSE, varsel = TRUE)
bigkm = comb_bkmrfits(fitkm.list)
ests = ExtractEsts(bigkm)
ExtractPIPs(bigkm)
pred.resp.univar <- PredictorResponseUnivar(fit = bigkm)
risks.overall <- OverallRiskSummaries(fit = bigkm, y = y, Z = Z, X = X,
  qs = seq(0.25, 0.75, by = 0.05), q.fixed = 0.5, method = "exact")

# additional objects that are not in a standard bkmrfit object:
summary(bigkm$iters)
table(bigkm$chain)
}

closeAllConnections()

}
