% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_test_message.R
\name{prepare_test_message}
\alias{prepare_test_message}
\title{Prepare a email test message object}
\usage{
prepare_test_message()
}
\description{
Create an email test message object,
which is helpful for sending a test
message with the \code{send_email_out()}
function.
}
\examples{
\dontrun{
# Create a credentials file to
# send via Gmail (this will be named
# `.bls_smtp_gmail_com`)
create_email_creds_file(
  user = "username@gmail.com",
  password = "*************",
  provider = "gmail",
  sender = "Sender Name")

# Send oneself a test message to
# test these new SMTP settings
send_email_out(
  message = prepare_test_message(),
  sender = "Sender Name",
  subject = "test 2",
  from = "username@gmail.com",
  to = "username@gmail.com",
  creds_file = ".bls_smtp_gmail_com")
}
}
