% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ggplot.R
\name{add_ggplot}
\alias{add_ggplot}
\title{Create an HTML fragment for an embedded ggplot image}
\usage{
add_ggplot(plot_object, width = 5, height = 5, alt = NULL)
}
\arguments{
\item{plot_object}{The \code{ggplot2} plot object.}

\item{width}{The width of the output plot in inches.}

\item{height}{The height of the output plot in inches.}

\item{alt}{Text description of image passed to the \code{alt} attribute inside of
the image (\code{<img>}) tag for use when image loading is disabled and on
screen readers. Defaults to the \code{ggplot2} plot object's title, if exists.
Override by passing a custom character string or \code{""} for no text.}
}
\value{
A character object with an HTML fragment that can be placed inside
the message body wherever the plot image should appear.
}
\description{
Add an ggplot plot inside the body of the email with this helper function.
}
\examples{
library(ggplot2)

# Create a ggplot plot
plot <-
  ggplot(
    data = mtcars,
    aes(x = disp, y = hp,
        color = wt, size = mpg)) +
  geom_point()

# Create an HTML fragment that
# contains an the ggplot as an
# embedded plot
plot_html <-
  add_ggplot(plot_object = plot)

# Include the plot in the email
# message body by simply referencing
# the `plot_html` object
email <-
  compose_email(
    body = md(
      c(
"Hello!

Here is a plot that will change
the way you look at cars forever.\\n",
plot_html,
"Let me know what you think
about it!"
      )
    )
  )

if (interactive()) email

}
