% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_hierseg.R
\name{compute_hierseg}
\alias{compute_hierseg}
\title{Block segmentation using hierarchical algorithm}
\usage{
compute_hierseg(
  suff_stats,
  family,
  lambda = 1,
  nrow,
  ncol,
  pen_func = bic_loss,
  min_block_size = min_block_size,
  max_blocks = NULL
)
}
\arguments{
\item{suff_stats}{Sufficient statistics to perform change point analysis}

\item{family}{The name of the family used to fit the model}

\item{lambda}{Penalization constant}

\item{nrow}{Number of rows or samples}

\item{ncol}{Number of columns or variables}

\item{pen_func}{A penalization function defined i integer intervals
The function signature should be pen(left_index, right_index, nrow, ncol),
where the left_index:right_index is the integer interval, nrow the sample
size and ncol the number of variables/columns.}

\item{min_block_size}{Minimum block size allowed. Default is 0, and the value
must be smaller or equal to ncol.}

\item{max_blocks}{Threshold on the number of block segments to fit the model.
Set low values for this parameters if having performance issues on large
data sets.}
}
\description{
Uses binary splitting to obtain a greedy solution to the regularized loss
optimization problem. Should be called within
\link[=fit_blockcpd]{fit_blockcpd}
}
