% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hugo.R
\name{shortcode}
\alias{shortcode}
\alias{shortcode_html}
\title{Helper functions to write Hugo shortcodes using the R syntax}
\usage{
shortcode(.name, ..., .content = NULL, .type = "markdown")

shortcode_html(...)
}
\arguments{
\item{.name}{The name of the shortcode.}

\item{...}{All arguments of the shortcode (either all named, or all unnamed).
The \code{...} argument of \code{shortcode_html()} is passed to
\code{shortcode()}.}

\item{.content}{The inner content for the shortcode.}

\item{.type}{The type of the shortcode: \code{markdown} or \code{html}.}
}
\value{
A character string wrapped in \code{htmltools::HTML()};
  \code{shortcode()} returns a string of the form \code{{{\% name args \%}}},
  and \code{shortcode_html()} returns \code{{{< name args >}}}.
}
\description{
These functions return Hugo shortcodes with the shortcode name and arguments
you specify. The closing shortcode will be added only if the inner content is
not empty. The function \code{shortcode_html()} is essentially
\code{shortcode(.type = 'html')}.
}
\details{
These functions can be used in either \pkg{knitr} inline R expressions or
code chunks. The returned character string is wrapped in
\code{htmltools::\link[htmltools]{HTML}()}, so  \pkg{rmarkdown} will protect
it from the Pandoc conversion. You cannot simply write \code{{{< shortcode
>}}} in R Markdown, because Pandoc is not aware of Hugo shortcodes, and may
convert special characters so that Hugo can no longer recognize the
shortcodes (e.g. \code{<} will be converted to \code{&lt;}).

If your document is pure Markdown, you can use the Hugo syntax to write
shortcodes, and there is no need to call these R functions.
}
\examples{
library(blogdown)

shortcode("tweet", "1234567")
shortcode("figure", src = "/images/foo.png", alt = "A nice figure")
shortcode("highlight", "bash", .content = "echo hello world;")

shortcode_html("myshortcode", .content = "My <strong>shortcode</strong>.")
}
\references{
\url{https://gohugo.io/extras/shortcodes/}
}
