% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustDBN.R
\name{clustDBN}
\alias{clustDBN}
\title{DBN-based clustering}
\usage{
clustDBN(
  dbndata,
  staticnodes = 0,
  blacklist = NULL,
  edgepmat = NULL,
  kclust = 2,
  chixi = 0.5,
  seed = 100,
  err = 1e-06,
  maxEM = 10,
  hardlim = 6,
  deltahl = 2,
  nit = 5,
  epmatrix = TRUE,
  plus1it = 4,
  nruns = 1,
  startpoint = "mclustPCA",
  baseprob = 0.4,
  commonspace = TRUE,
  verbose = TRUE,
  samestruct = TRUE,
  pickmax = TRUE
)
}
\arguments{
\item{dbndata}{data matrix; rows are observations, columns are variables; static nodes have to be in the first column of the data}

\item{staticnodes}{(integer) number of static nodes in a DBN}

\item{blacklist}{adjacency matrix containing information about which edges will be blacklisted in structure search}

\item{edgepmat}{penalization matrix of the edges in structure learning}

\item{kclust}{the number of clusters (mixture components)}

\item{chixi}{prior pseudocounts used for computing parameters for binary nodes}

\item{seed}{integer number set for reproducibility}

\item{err}{convergence criteria}

\item{maxEM}{maximum number of EM iterations (structural)}

\item{hardlim}{maximum number of parents per node when learning networks}

\item{deltahl}{additional number of parents when sampling from the common search space}

\item{nit}{number of internal iteration in structural EM}

\item{epmatrix}{(logical) indicates if the matrices containing posterioir probabilities of single edges should be returned}

\item{plus1it}{maximum number of search space expansion iterations when performing structure search}

\item{nruns}{number of runs of the EM algorithm}

\item{startpoint}{defines which algorithm is used to define starting cluster memberships: possible values "random", "mclustPCA" and "mclust"}

\item{baseprob}{defines the base probability of cluster membership when "mclustPCA" or "mclust" used as starting point}

\item{commonspace}{(logical) defines if the sampling has to be performed from the common search space}

\item{verbose}{defines if the output messages should be printed}

\item{samestruct}{(logical) defines if initial and intrinsic part of transition structures should be the same}

\item{pickmax}{(logical) if TRUE only maximum EM run is returned}
}
\value{
object of class 'bnclustOmics' containing the results of Bayesian-network based clustering: cluster assignments, networks representing the clusters
}
\description{
This function can be used for DBN-based clustering. It is the same function as bnclustOmics, but it also works for time series data.
}
\author{
Polina Suter
}
