% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.covariate.plot}
\alias{network.covariate.plot}
\title{Make a covariate plot}
\usage{
network.covariate.plot(
  result,
  base.treatment = NULL,
  comparison.treatment = NULL,
  base.category = NULL,
  comparison.category = NULL,
  covariate.name = NULL
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{base.treatment}{Base treatment for relative effect}

\item{comparison.treatment}{Treatment comparing against base treatment}

\item{base.category}{Base category for multinomial data. Note that category in multinomial denotes which column it is in the Outcomes matrix. Thus, this should be a numeric value.}

\item{comparison.category}{Comparison category for multinomial data}

\item{covariate.name}{A vector of covariate names of the covariate that goes into x-axis label}
}
\value{
None
}
\description{
This function makes a covariate plot of how the relative effect changes as the covariate value changes.
User needs to specify one base treatment and one comparison treatment to make this plot (base category and comparison category is also needed for multinomial).
The function uses the \code{\link{relative.effects}} to calculate the correct relative effect. 2.5\%, median, and 97.5\% C.I. are drawn.
}
\examples{
########### certolizumab (with covariate)
network <- with(certolizumab, {
 network.data(Outcomes, Study, Treat, N=N, response="binomial", Treat.order,
 covariate = covariate, hy.prior = list("dhnorm", 0, 9.77))
})
\donttest{
result <- network.run(network)
network.covariate.plot(result, base.treatment = "Placebo", comparison.treatment = "CZP",
covariate.name = "Disease Duration")
}
}
