% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.network.R
\name{summary.nodesplit.network.result}
\alias{summary.nodesplit.network.result}
\title{Summarize result run by \code{\link{nodesplit.network.run}}}
\usage{
\method{summary}{nodesplit.network.result}(object, ...)
}
\arguments{
\item{object}{Result object created by \code{\link{nodesplit.network.run}} function}

\item{...}{Additional arguments affecting the summary produced}
}
\value{
Returns summary of the nodesplit network model result
}
\description{
This function uses summary function in coda package to summarize mcmc.list object. Monte carlo error (Time-series SE) is also obtained using the coda package and is printed in the summary as a default.
}
\examples{
###Parkinsons data example
network <- with(parkinsons, {
 nodesplit.network.data(Outcomes, Study, Treat, SE = SE, response = "normal", 
 Treat.order = Treat.order, pair = c("Placebo", "Ropinirole"))
})
\donttest{
result <- nodesplit.network.run(network)
summary(result)
}
}
