% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BN-methods.R
\name{dag.to.cpdag}
\alias{dag.to.cpdag}
\title{convert a DAG to a CPDAG}
\usage{
dag.to.cpdag(dag.adj.matrix, layering = NULL)
}
\arguments{
\item{dag.adj.matrix}{the adjacency matrix representing the DAG of a \code{\link{BN}}.}

\item{layering}{vector containing the layers each node belongs to.}
}
\value{
the adjacency matrix representing a CPDAG for the network.
}
\description{
Convert the adjacency matrix representing the DAG of a \code{\link{BN}}
into the adjacency matrix representing a CPDAG for the network.
}
\examples{
\dontrun{
net <- learn.network(dataset, layering=layering)
pdag <- dag.to.cpdag(dag(net), layering)
wpdag(net) <- pdag
}
}
\seealso{
\code{\link{wpdag.from.dag}}
}

