% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_seqspec}
\alias{bold_seqspec}
\title{Get BOLD specimen + sequence data.}
\usage{
bold_seqspec(taxon = NULL, ids = NULL, bin = NULL, container = NULL,
  institutions = NULL, researchers = NULL, geo = NULL, marker = NULL,
  response = FALSE, callopts = list(), format = "tsv", sepfasta = FALSE)
}
\arguments{
\item{taxon}{(character) Returns all records containing matching taxa. Taxa includes the ranks of
phylum, class, order, family, subfamily, genus, and species.}

\item{ids}{(character) Returns all records containing matching IDs. IDs include Sample IDs,
Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) Returns all records contained in matching BINs. A BIN is defined by a
Barcode Index Number URI.}

\item{container}{(character) Returns all records contained in matching projects or datasets.
Containers include project codes and dataset codes}

\item{institutions}{(character) Returns all records stored in matching institutions. Institutions
are the Specimen Storing Site.}

\item{researchers}{(character) Returns all records containing matching researcher names.
Researchers include collectors and specimen identifiers.}

\item{geo}{(character) Returns all records collected in matching geographic sites. Geographic
sites includes countries and province/states.}

\item{response}{(logical) Note that response is the object that returns from the Curl call,
useful for debugging, and getting detailed info on the API call.}

\item{callopts}{(character) curl debugging opts passed on to httr::GET}

\item{marker}{(character) Returns all records containing matching marker codes.}

\item{format}{(character) One of xml or tsv (default). tsv format gives back a data.frame
object. xml gives back parsed xml as a}

\item{sepfasta}{(logical) If TRUE, the fasta data is separated into a list with names matching
the processid's from the data frame}
}
\value{
Either a data.frame, parsed xml, a httr response object, or a list with length two
(a data.frame w/o nucleotide data, and a list with nucleotide data)
}
\description{
Get BOLD specimen + sequence data.
}
\examples{
\dontrun{
bold_seqspec(taxon='Osmia')
bold_seqspec(taxon='Osmia', format='xml')
bold_seqspec(taxon='Osmia', response=TRUE)
res <- bold_seqspec(taxon='Osmia', sepfasta=TRUE)
res$fasta[1:2]
res$fasta['GBAH0293-06']
}
}

