% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_circ}
\alias{coef_circ}
\title{Circular coefficients}
\usage{
coef_circ(object, type = "continuous", units = "radians")
}
\arguments{
\item{object}{an object used to select a method.}

\item{type}{one of \code{c("continuous", "categorical")} to get either the
coefficients for the continuous or categorical predictor variables.}

\item{units}{one of \code{c("degrees", "radians")} to get categorical
coefficients estimates and estimates for \code{$a_c$} in degrees or
radians.}
}
\description{
\code{coef_circ} gives posterior summaries of the circular coefficients.
}
\details{
the methods \link[bpnreg]{coef_circ.bpnr} and
  \link[bpnreg]{coef_circ.bpnme} have their own help page.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
coef_circ(fit.Motor)
coef_circ(fit.Motor, type = "categorical")

}
