% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{infactor_or2}
\alias{infactor_or2}
\title{Inefficiency factor for ordinal quantile model
with 3 outcomes}
\usage{
infactor_or2(x, beta, sigma, autocorrelationCutoff)
}
\arguments{
\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of coefficients of dimension \eqn{(k x nsim)}.}

\item{sigma}{Gibbs draw of scale factor.}

\item{autocorrelationCutoff}{cut-off to identify the number of lags.}
}
\value{
Returns a list with components
\itemize{
\item{\code{inefficiencyBeta}: }{vector with inefficiency factor for each \eqn{\beta}.}
\item{\code{inefficiencySigma}: }{vector with inefficiency factor for each \eqn{\sigma}.}
}
}
\description{
This function calculates the inefficiency factor from the MCMC draws
of \eqn{(\beta, \sigma)} for ordinal quantile model with 3 outcomes. The
inefficiency factor is calculated using the batch-means method.
}
\details{
Calculates the inefficiency factor of \eqn{(\beta, \sigma)} using the batch-means
method.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y, x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25, display = FALSE)
beta <- output$beta
sigma <- output$sigma

inefficiency <- infactor_or2(x, beta, sigma, 0.5)

# Summary of Inefficiency Factor:
#            Inefficiency
# beta_0       2.0011
# beta_1       1.6946
# beta_2       1.4633
# sigma        2.6590

}
\references{
Greenberg, E. (2012). “Introduction to Bayesian Econometrics.”
 Cambridge University Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
pracma, \link[stats]{acf}
}
