% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{dicOR2}
\alias{dicOR2}
\title{Deviance Information Criterion in the OR2 model}
\usage{
dicOR2(y, x, betadraws, sigmadraws, gammacp, postMeanbeta,
postMeansigma, burn, mcmc, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{betadraws}{dataframe of the MCMC draws of \eqn{\beta}, size is \eqn{(k x nsim)}.}

\item{sigmadraws}{dataframe of the MCMC draws of \eqn{\sigma}, size is \eqn{(nsim x 1)}.}

\item{gammacp}{row vector of cut-points including -Inf and Inf.}

\item{postMeanbeta}{posterior mean of the MCMC draws of \eqn{\beta}.}

\item{postMeansigma}{posterior mean of the MCMC draws of \eqn{\sigma}.}

\item{burn}{number of burn-in MCMC iterations.}

\item{mcmc}{number of MCMC iterations, post burn-in.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdeviance - dev}
\deqn{pd = avgdeviance - dev}
\deqn{dev = -2*(logLikelihood)}.
}
\description{
Function for computing the DIC in the OR2 model (ordinal quantile
model with exactly 3 outcomes).
}
\details{
Deviance is -2*(log likelihood) and has an important role in
statistical model comparison because of its relation with Kullback-Leibler
information criterion.

This function provides the DIC, which can be used to compare two or more models at the
same quantile. The model with a lower DIC provides a better fit.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
k <- dim(xMat)[2]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
n0 <- 5
d0 <- 8
output <- quantregOR2(y = y, x = xMat, b0, B0, n0, d0, gammacp2 = 3,
burn = 10, mcmc = 40, p = 0.25, accutoff = 0.5, maxlags = 400, verbose = FALSE)
betadraws <- output$betadraws
sigmadraws <- output$sigmadraws
gammacp <- c(-Inf, 0, 3, Inf)
postMeanbeta <- output$postMeanbeta
postMeansigma <- output$postMeansigma
mcmc = 40
burn <- 10
nsim <- burn + mcmc
dic <- dicOR2(y, xMat, betadraws, sigmadraws, gammacp,
postMeanbeta, postMeansigma, burn, mcmc, p = 0.25)

# DIC
#   801.8191
# pd
#   6.608594
# dev
#   788.6019

}
\references{
Spiegelhalter, D. J., Best, N. G., Carlin, B. P. and Linde, A. (2002).
`"Bayesian Measures of Model Complexity and Fit."` Journal of the
Royal Statistical Society B, Part 4: 583-639. DOI: 10.1111/1467-9868.00353

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
`"Bayesian Data Analysis."` 2nd Edition, Chapman and Hall. DOI: 10.1002/sim.1856
}
\seealso{
decision criteria
}
