% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mats.R
\name{create_mats}
\alias{create_mats}
\title{Create connection matrices for tractography or fMRI data}
\usage{
create_mats(A.files, modality = c("dti", "fmri"), divisor = c("none",
  "waytotal", "size", "rowSums"), div.files = NULL, threshold.by = c("raw",
  "density"), mat.thresh = 0, sub.thresh = 0.5, inds,
  algo = c("probabilistic", "deterministic"), P = 5000)
}
\arguments{
\item{A.files}{Character vector of the filenames with connection matrices}

\item{modality}{Character string indicating data modality (default:
\code{dti})}

\item{divisor}{Character string indicating how to normalize the connection
matrices; either 'none' (default), 'waytotal', 'size', or 'rowSums'
(ignored if \code{modality} equals \code{fmri})}

\item{div.files}{Character vector of the filenames with the data to
normalize by (e.g. a list of \emph{waytotal} files) (default: \code{NULL})}

\item{threshold.by}{Character string indicating how to threshold the data;
choose \code{density} if you want all resulting matrices in a subject group
to have the same density (default: \code{raw})}

\item{mat.thresh}{Numeric (vector) for thresholding connection matrices
(default: 0)}

\item{sub.thresh}{Numeric (between 0 and 1) for thresholding by subject
numbers (default: 0.5)}

\item{inds}{List (length equal to number of groups) of integers; each list
element should be a vector of length equal to the group sizes}

\item{algo}{Character string of the tractography algorithm used (default:
\code{'probabilistic'})}

\item{P}{Integer; number of samples generated using FSL (default: 5000)}
}
\value{
A list containing:
\item{A}{A 3-d array of the raw connection matrices}
\item{A.norm}{A 3-d array of the normalized connection matrices}
\item{A.bin}{A 3-d array of binarized connection matrices}
\item{A.bin.sums}{A list of 2-d arrays of connection matrices, with each
  entry signifying the number of subjects with a connection present; the
  number of list elements equals the length of \code{mat.thresh}}
\item{A.inds}{A list of arrays of binarized connection matrices, containing 1
  if that entry is to be included}
\item{A.norm.sub}{A list of 3-d arrays of the normalized connection matrices
  for all given thresholds}
\item{A.norm.mean}{A list of 2-d arrays of the normalized connection matrices
  averaged for each group}
}
\description{
This function will take a vector of filenames which contain connection
matrices (e.g. the \emph{fdt_network_matrix} files from FSL or the
\emph{ROICorrelation.txt} files from DPABI) and create arrays of this data.
You may choose to normalize these matrices by the \emph{waytotal} or
\emph{region size} (tractography), or not at all (fMRI).
}
\details{
The argument \code{mat.thresh} allows you to choose a numeric threshold,
below which the connections will be replaced with 0; this argument will also
accept a numeric vector. The argument \code{sub.thresh} will keep only those
connections for which at least \emph{X}\% of subjects have a positive entry
(the default is 0.5, or 50\%).
}
\examples{
\dontrun{
thresholds <- seq(from=0.001, to=0.01, by=0.001)
my.mats <- create_mats(f.A, modality='fmri', threshold.by='raw',
  mat.thresh=thresholds, sub.thresh=0.5, inds=inds)
dti.mats <- create_mats(f.A, divisor='waytotal', div.files=f.way,
  mat.thresh=thresholds, sub.thresh=0.5, inds=inds)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
