% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R, R/glm_fit.R, R/utils.R
\name{GLM helpers}
\alias{GLM helpers}
\alias{setup_glm}
\alias{contrast_names}
\alias{check_if_singular}
\alias{add_nans}
\alias{cxtxfun_3d}
\alias{glm_data_table}
\alias{matrix2list}
\alias{maxfun}
\alias{sortfun}
\title{Helper functions to set-up for GLM analyses}
\usage{
setup_glm(g.list, level, covars, X, contrasts, con.type, con.name, measure,
  outcome, ...)

contrast_names(contrasts, con.type, con.name, X)

check_if_singular(QR)

add_nans(fits, dimX, namesX, runX = names(fits$qr))

cxtxfun_3d(con.type, transpose = TRUE)

glm_data_table(g.list, level, measure)

matrix2list(mat)

maxfun(alternative)

sortfun(alternative)
}
\arguments{
\item{g.list}{A \code{brainGraphList} object}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{covars}{A \code{data.table} of covariates}

\item{X}{Numeric matrix, if you wish to supply your own design matrix.
Ignored if \code{outcome != measure}.}

\item{contrasts}{Numeric matrix (for T statistics) or list of matrices (for F
statistics) specifying the contrast(s) of interest; if only one contrast is
desired, you can supply a vector (for T statistics)}

\item{con.type}{Either \code{'t'} or \code{'f'}}

\item{con.name}{Character vector of the contrast name(s); if \code{contrasts}
has row/list names, those will be used for reporting results}

\item{measure}{Character string of the graph measure of interest}

\item{outcome}{Character string specifying the name of the outcome variable,
if it differs from the graph metric (\code{measure})}

\item{...}{Arguments passed to \code{\link{brainGraph_GLM_design}}}

\item{QR}{List of QR decompositions for each design matrix}

\item{fits}{List object output by one of the model fitting functions (e.g.,
\code{\link{fastLmBG}})}

\item{dimX}{Integer vector containing the dimensions of the original design
matrix/array (including singular designs)}

\item{namesX}{List of character vectors containing the dimension names from
the original design matrix/array}

\item{runX}{Character vector of regions for which models were fit}

\item{transpose}{Logical indicating whether to transpose the output of the
selected function. Ignored for F-contrasts. Should be \code{FALSE} for
T-contrasts when the \dQuote{Guttman} partition method is used. Default:
\code{TRUE}}

\item{mat}{Numeric matrix in which each row is a single contrast vector}

\item{alternative}{Character string, whether to do a two- or one-sided test.
Default: \code{'two.sided'}}
}
\value{
\code{contrast_names} -- list containing the contrasts (matrix or
  list), contrast names, and number of contrasts

\code{add_nans} -- the original \code{fits} object with \code{NaN} or
  \code{NA} inserted

\code{cxtxfun_3d} -- A function with arguments for the contrast
  (numeric matrix), the \dQuote{unscaled covariance} array, the (row) rank of
  the contrast, and the number of regions in the analysis (only used for
  F-contrasts)

\code{glm_data_table} - A \code{data.table} with one column
  containing the subject ID's and 1 or more columns with the graph- or
  vertex-level measure of interest.

\code{matrix2list} -- A list with length equal to the number of rows
  of \code{C}
}
\description{
\code{setup_glm} is used to setup the data/objects for any function that uses
the main GLM functionality in \code{brainGraph}.

\code{contrast_names} checks the dimensions of contrasts, generates contrast
names, and sets column names for GLM functions. For F-contrasts, if a
\code{matrix} is given, it converts it to a \code{list} to simplify processing
later.

\code{add_nans} adds rows/columns (or higher dimensions) to model fit data
for regions which were skipped (due to having a singular design matrix,
usually).

\code{cxtxfun_3d} returns a function that calculates the \dQuote{CXtX}
matrix/array, used to calculate the standard error of a contrast. The
function signature will be \code{f(contrast, xtx, rkC, ny)}.

\code{glm_data_table} is used in \code{brainGraph_GLM} and
\code{brainGraph_mediate} to create a \code{data.table} with the
\emph{subject IDs} and column(s) for the graph- or vertex-level metric of
interest.

\code{matrix2list} makes working with different contrast types (i.e., t or F)
a little simpler.
}
\details{
This function: removes unused levels from \code{covars} and \code{DT.y.m},
removes subjects with incomplete data, creates a design matrix (if not
supplied), and supplies names to the contrast matrix.

The \dQuote{CXtX} matrix/array for T-contrasts is the diagonal of
\deqn{C (X^T X)^{-1} C^T}
For F-contrasts, it is the \emph{inverse} of the matrix:
\deqn{(C (X^T X)^{-1} C^T)^{-1}}
where in both cases, \eqn{C} is the contrast matrix and \eqn{X} is the design
matrix/array.

For T-contrasts, the function will return a numeric vector/matrix with
dimensions \eqn{k \times r} where \eqn{k} is the \emph{number} of contrasts
(i.e., the number of rows in the contrast matrix) and \eqn{r} is the number
of regions. For F-contrasts, the function would return a numeric array with
dimensions \eqn{k \times k \times r}, where \eqn{k} is the rank of the
contrast matrix and \eqn{r} is the number of regions. If there is a single
design for all regions, it will be a \eqn{k \times k} matrix.
}
\keyword{internal}
