% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/70_plotup.R
\name{plotup}
\alias{plotup}
\title{Presents a specific graphic explicitly called by name.}
\usage{
plotup(data, vars, diagram, output = "html", dir = tempdir())
}
\arguments{
\item{data}{Data.frame. Default dataset to use for plot. If not already a
data.frame, it should be first coerced to by [as.data.frame()].}

\item{vars}{Character. A variable within the dataset.}

\item{diagram}{Character. A specific graphic to be presented within the ones
considered by the 'logical', 'ordered', 'factor', 'character', 'datetime' and 'numeric'
arguments of the 'wideplot()' function.}

\item{output}{Character. Type of output.
\itemize{
  \item \emph{'html'}: default output is a html webpage.
  \item \emph{'plots pane'}: output in RStudio's plots pane.
  \item \emph{'console'}: shows the code that produces a particular graphic.
}}

\item{dir}{Directory in which the files are stored.}
}
\value{
This function can have three outputs: by default it produces a particular graphic,
but it can also be represented into the RStudio's plots pane, or can return the code to produce it.
}
\description{
In order to present the graphic, the user must define a dataset, a
variable whitin this dataset and a compatible type of graphic.
Future work will include graphics that involve more than one variable.
}
\examples{
plotup(iris, "Petal.Width", "color heatmap", output = "plots pane")
plotup(iris, "Petal.Width", "color heatmap", output = "console")
}
