% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individuals-Methods.R
\docType{methods}
\name{getIndividualsLife}
\alias{getIndividualsLife}
\alias{getIndividualsLife,Individuals-method}
\title{Method to get Individuals Life information}
\usage{
getIndividualsLife(object, ...)

\S4method{getIndividualsLife}{Individuals}(object)
}
\arguments{
\item{object}{An Individuals object}

\item{...}{other parameters}
}
\value{
a matrix indexed by individual ID in rows and by time in columns.
}
\description{
Get individuals toxic concentration over the simulation time and return life states for individuals.
}
\details{
If intern concentration overtakes the toxic threshold value is "-2", that means the individual is dead because of higher toxic concentration.
Otherwise value is "-1" means the individual is dead in natural way. The value "0" means that the individual is not alive yet.
}
\examples{
# the fifth first individuals states for each time step
data(maize_65)
life<-getIndividualsLife(maize.individuals)
matplot(1:10,life[1:10,],type='l',col=1:5,xlab="source",ylab="states")
}
